const {
    READ_4BYTE,
    WRITE_4BYTE,
    WRITE_FLOAT,
    messageCreator
} = require("./MessageCreator");
// const {
//     SPEAKER_CLASSIFICATION,
//     SERIES_OF_SPEAKERS
// } = require('../../data/presets/speaker');
// const fs = require('fs');
// const path = require("path");
const _ = require("underscore");
const constants = require('../../constants');

class FunktionsLib {
    /**
     * @param {name String} params String name
     * @param {nr 1..21} params String nr
     * @param {speakerslots array} params list speakerslots
     */
    setPresetName(params) {
        var str = "";
        var presetNameLength = params.name.length;
        for (var i = 0; i < (16 - presetNameLength); i++) {
            str = str + " ";
        }
        if (params.speakerslots) {
            str = str +
            String.fromCharCode(params.speakerslots[0]) +
            String.fromCharCode(params.speakerslots[1]) +
            String.fromCharCode(params.speakerslots[2]) +
            String.fromCharCode(params.speakerslots[3]);
        } else {
            str = str + "    ";
        }

        str = params.name + str;
        return {
            packable: true,
            data: messageCreator.makeMessage(9, params.nr + 9, str, str.length, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {name String} params String name
     */
    setUserBank1(params) {
        var str = "";
        if (params.name.length < 16) {
            for (var i = 0; i < (16 - params.name.length); i++) {
                str = str + " ";
            }
        }
        str = params.name + str;
        return {
            packable: true,
            data: messageCreator.makeMessage(9, 3, str, str.length, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {name String} params String name
     */
    setUserBank2(params) {
        var str = "";
        if (params.name.length < 16) {
            for (var i = 0; i < (16 - params.name.length); i++) {
                str = str + " ";
            }
        }
        str = params.name + str;
        return {
            packable: true,
            data: messageCreator.makeMessage(9, 4, str, str.length, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {name String} params String name
     */
    setUserName(params) {
        var str = "";
        if (params.name.length < 16) {
            for (var i = 0; i < (16 - params.name.length); i++) {
                str = str + " ";
            }
        }
        str = params.name + str;
        return {
            packable: true,
            data: messageCreator.makeMessage(9, 8, str, str.length, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {name String} params String name
     */
    setSpeakerLibName(params) {
        var str = "";
        if (params.name.length < 16) {
            for (var i = 0; i < (16 - params.name.length); i++) {
                str = str + " ";
            }
        }
        str = params.name + str;
        return {
            packable: true,
            data: messageCreator.makeMessage(9, 6, str, str.length, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {name String} params String name
     */
    setPresetLibName(params) {
        var str = "";
        if (params.name.length < 16) {
            for (var i = 0; i < (16 - params.name.length); i++) {
                str = str + " ";
            }
        }
        str = params.name + str;
        return {
            packable: true,
            data: messageCreator.makeMessage(9, 9, str, str.length, null, WRITE_4BYTE)
        }
    }

    storeLiveParameters() {
        return {
            packable: true,
            data: messageCreator.makeMessage(5, 12, 0, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {nr = 0...63} params
     */
    storePreset(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(5, 12, params.nr, 4, null, WRITE_4BYTE)
        }
    }
    /**
     *
     * @param {nr nr from speaker.js} nr
     * @param {channelId 0..3} params
     */
    storeSpeaker(params) {
        var storeingPlaceOffSet = constants.SLOT_LIVE_SPEAKER_CH0;
        var storingplace = params.channelId + storeingPlaceOffSet;
        if (params.speakerSlot > 0) storingplace = params.speakerSlot - 9;
        return {
            packable: true,
            data: messageCreator.makeMessage(5, 13, storingplace, 4, null, WRITE_4BYTE)
        }
    }
    /**
     *
     * @param {nr SnapshotNr/PresetId 1..20} nr
     * @param {channelId 0..3} params
     */
    setActualSpeaker(params) {
        var storeingPlaceOffSet = constants.SLOT_LIVE_SPEAKER_CH0;
        var storingplace = params.channelId + storeingPlaceOffSet + (params.nr * 4);
        if (params.speakerSlot > 0) storingplace = params.speakerSlot - 9;
        return {
            packable: true,
            data: messageCreator.makeMessage(5, 100 + params.channelId, storingplace, 4, null, WRITE_4BYTE)
        }
    }

    rebootDevice() {
        return {
            packable: false,
            data: messageCreator.makeMessage(6, 3, 1234, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {islibUpdate true, false} islibUpdate
     * @param {nr = nr from speaker.js} nr
     * @param {name String} name
     * @param {channelId 0..3} channelId
     * @param {moduletype} moduletype
     * @param {clearSnapshotSpeaker} clearSnapshotSpeaker
     */
    setSpeakerName(params) {
        var sendName = "";
        var inputName = "SER_TIRAY-FF__PF";
        var speakerId = params.nr;
        var storeingPlace;
        var storeingPlaceOffSet = constants.SLOT_SPEAKER_OFFSET;
        if (params.clearSnapshotSpeaker) {
            sendName = "                            ";
            return {
                packable: true,
                data: messageCreator.makeMessage(9, params.nr, sendName, sendName.length, null, WRITE_4BYTE)
            }
        } else {
            storeingPlace = params.channelId + storeingPlaceOffSet;
            if (params.speakerSlot > 0) storeingPlace = params.speakerSlot;
            SPEAKER_CLASSIFICATION.forEach(element => {
                if (element.nr == params.nr) {
                    var type = element.type;
                    if (type == "CUE FOUR") type = "CUE 4";
                    var name14 = (storeingPlace - storeingPlaceOffSet + 1) + " " + element.name;
                    var runto = name14.length;
                    for (var i = 0; i < (14 - runto); i++) {
                        name14 = name14 + " ";
                    }

                    var waybits = String.fromCharCode(17);
                    if (element.ways == 2) {
                        if (element.waynr == 1) {
                            waybits = String.fromCharCode(32);
                        } else {
                            waybits = String.fromCharCode(34);
                        }
                    }

                    var cathegorieString;
                    var seriesNr = 0;
                    SERIES_OF_SPEAKERS.forEach(series => {
                        seriesNr++;
                        if (series == element.series) {
                            cathegorieString = String.fromCharCode(seriesNr + 64);
                        }
                    });
                    if (_.contains(["LINUSCON", "LINUS10", "LINUS14", "LINUS12C"], params.moduletype)) {
                        inputName = name14.substr(0, 14) + element.display1.substr(0, 5) + element.display2.substr(0, 5) + cathegorieString + waybits;
                    } else {
                        inputName = name14.substr(0, 14) + element.display1.substr(0, 5) + element.display2.substr(0, 5) + cathegorieString + waybits;
                    }
                    sendName = inputName + String.fromCharCode((0x00FF & speakerId)) + String.fromCharCode((speakerId >> 8));
                }
            });
            return {
                packable: true,
                data: messageCreator.makeMessage(9, storeingPlace, sendName, sendName.length, null, WRITE_4BYTE)
            }
        }
    }

    /**
     *
     * @param {nr nr from speaker.js} nr
     * @param {channslId 0..3} params
     */
    loadSpeakerToChannel(params) {
        var sidx = 14 + params.channelId
        var storeingPlaceOffSet = constants.SLOT_LIVE_SPEAKER_CH0;
        var storingplace = params.channelId + storeingPlaceOffSet;
        if (params.slotNr > 10) storingplace = params.slotNr - 9;
        return {
            packable: true,
            data: messageCreator.makeMessage(5, sidx, storingplace, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {presetNr} params
     */
    loadPreset(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(5, 10, params.presetNr, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {value false=off, true==on} value
     */
    setReplayInPackes(value) {
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 1, value ? 1 : 0, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {value false=off, true==on} value
     */
    setAutoSendUI(value) {
        return {
            packable: true,
            data: messageCreator.makeMessage(21, 1, value ? 1 : 0, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {value false=off, true==on} value
     */
    setSendLevelData(value) {
        return [{
            packable: true,
            data: messageCreator.makeMessage(6, 1, value ? 0 : 1, 4, null, WRITE_4BYTE)
        }, {
            packable: true,
            data: messageCreator.makeMessage(10, 15, value ? 1 : 0, 4, null, WRITE_4BYTE)
        }]
    }

    readSpeakerLibName() {
        return {
            packable: true,
            response: {
                id: "SpeakerLibName"
            },
            data: messageCreator.makeMessage(9, 6, 0, 0, null, READ_4BYTE)
        }
    }

    // eslint-disable-next-line camelcase
    readFirmwareOEM_id() {
        return {
            packable: true,
            response: {
                id: "FirmwareOEM_id"
            },
            data: messageCreator.makeMessage(9, 2, 0, 0, null, READ_4BYTE)
        }
    }

    readPresetLibName() {
        return {
            packable: true,
            response: {
                id: "PresetLibName"
            },
            data: messageCreator.makeMessage(9, 9, 0, 0, null, READ_4BYTE)
        }
    }

    readDeviceName() {
        return {
            packable: true,
            response: {
                id: "DeviceName"
            },
            data: messageCreator.makeMessage(9, 7, 0, 0, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {name String} params String name
     */
    setDeviceName(params) {
        var str = "";
        if (params.name.length < 16) {
            for (var i = 0; i < (16 - params.name.length); i++) {
                str = str + " ";
            }
        }
        str = params.name + str;
        return {
            packable: true,
            data: messageCreator.makeMessage(9, 7, str, str.length, null, WRITE_4BYTE)
        }
    }

    readUserName() {
        return {
            packable: true,
            response: {
                id: "UserName"
            },
            data: messageCreator.makeMessage(9, 8, 0, 0, null, READ_4BYTE)
        }
    }

    readUserBank1() {
        return {
            packable: true,
            response: {
                id: "UserBank1"
            },
            data: messageCreator.makeMessage(9, 3, 0, 0, null, READ_4BYTE)
        }
    }

    readUserBank2() {
        return {
            packable: true,
            response: {
                id: "UserBank2"
            },
            data: messageCreator.makeMessage(9, 4, 0, 0, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {SlotNr from ActualSpeaker} params
     */
    readSpeakerName(params) {
        return {
            packable: true,
            response: {
                id: "SpeakerName" + params.SlotNr
            },
            data: messageCreator.makeMessage(9, params.SlotNr, 0, 0, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {nr} params
     */
    readPresetName(params) {
        return {
            packable: true,
            response: {
                id: "PresetName" + params.nr
            },
            data: messageCreator.makeMessage(9, params.nr + 9, 0, 0, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {channelId} params
     */
    getSensorEnabled(params) {
        return {
            packable: true,
            response: {
                id: "SensorEnabled" + params.channelId
            },
            data: messageCreator.makeMessage(6, 60, 0, 0, null, READ_4BYTE)
        }
    }

    getSensorDetected() {
        return {
            packable: true,
            response: {
                id: "SensorDetected"
            },
            data: messageCreator.makeMessage(6, 61, 0, 0, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {blinktime 1..30 in seconds} params
     */
    identify(params) {
        return [{
            packable: true,
            data: messageCreator.makeMessage(7, 11, params.blinktime, 4, null, WRITE_4BYTE)
        }, {
            packable: true,
            data: messageCreator.makeMessage(7, 10, 1, 4, null, WRITE_4BYTE)
        }]
    }
    /**
     *
     * @param {amptype "LINUS10C .. etc"} amptype
     * @param {channelId 0..3} channelId
     */
    getAmpModuleState(params) {
        return {
            packable: true,
            response: {
                id: "AmpModuleState"
            },
            data: messageCreator.makeMessage(8, (11 + params.channelId), 0, 0, null, READ_4BYTE)
        }
    }
    /**
     *
     * @param {amptype} params
     */
    setHardwareAmpStandby(params) {
        // setamppower 6.9
        var sidx = 9;
        var idx = 6;
        var value = params.value ? 0 : 1;
        if (params.amptype == "LINUS10C" || params.amptype == "LINUS5C") {
            sidx = 8;
            idx = 6;
        }
        return {
            packable: true,
            data: messageCreator.makeMessage(idx, sidx, value, 4, null, WRITE_4BYTE)
        }
    }
    /**
     *
     * @param {amptype} params
     */
    getHardwareAmpStatus(params) {
       var sidx = 20;
       var idx = 6;
       if (params.amptype == "LINUS10C" || params.amptype == "LINUS5C") {
        sidx = 10;
        idx = 8;
       }
        return {
            packable: true,
            response: {
                id: "HardwareAmpStatus"
            },
            data: messageCreator.makeMessage(idx, sidx, 0, 0, null, READ_4BYTE)
        }
    }

    requestOkMessage() {
        return {
            packable: true,
            response: {
                id: "OkMessage"
            },
            data: messageCreator.makeMessage(10, 9, 10, 4, null, WRITE_4BYTE)
        }
    }
    /**
     *
     * @param {value false=off, true==on} value
     */
    setOkMessage(value) {
        return {
            packable: true,
            data: messageCreator.makeMessage(10, 9, value ? 1 : 0, 4, null, WRITE_4BYTE)
        }
    }
    /**
     *
     * @param {value false=off, true==on} value
     */
    setAutoTest(value) {
        return {
            packable: true,
            data: messageCreator.makeMessage(18, 1, value ? 1 : 0, 4, null, WRITE_4BYTE)
        }
    }
    /**
     *
     * @param {value ipa example: "192.168.1.2"} value
     */
    setIpAddress(params) {
        const ipPartArray = this.ipToArray(params.value);
        const ipaint = (ipPartArray[0] + (ipPartArray[1] << 8) + (ipPartArray[2] << 16) + (ipPartArray[3] << 24));
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 7, ipaint, 4, null, WRITE_4BYTE)
        }
    }
    /**
     * helper only
     * @param {*} ip
     */
    ipToArray(ip) {
        return ip.split(".").map(part => parseInt(part));
    }
    /**
     *
     * @param {value false=off, true==on} value
     * @param {channelId 0..3} channelId
     */
    setMute(params) {
        var outMute = 22;
        var channelBias = 14;
        var channelMult = 1;
        return {
            requestOkMessage: false,
            packable: true,
            data: messageCreator.makeMessage(outMute, channelBias + params.channelId * channelMult, params.value ? 1 : 0, 4, null, WRITE_4BYTE)
        }
    }
    /**
     *
     * @param {channelId 0..3} channelId
     */
    getMute(params) {
        var outMute = 22;
        var channelBias = 14;
        var channelMult = 1;
        return {
            packable: true,
            response: {
                id: "Mute",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(outMute, channelBias + params.channelId * channelMult, 0, 0, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {value -120.0..12.0} value
     * @param {channelId 0..3} channelId
     */
    setGain(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(100 + params.channelId, 10, params.value * 10, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getGain(params) {
        var inGain = 20;
        var channelBias = 10; var
        channelMult = 4;
        return {
            packable: true,
            response: {
                id: "Gain",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(inGain, channelBias + params.channelId * channelMult, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {value 0.0104 or 0.0208..1000} value
     * @param {channelId 0..3} channelId
     * @param {amptype 1==LINUS10 or LINUS14 or LINUSCON or LINUS12C, 2==LINUS10C or LINUS5C} amptype
     */
    setDelay(params) {
        var value = Math.round(params.value * 96 / params.amptype);
        if (!params.amptype) {
            value = Math.round(params.value * 96);
        }
        return {
            packable: true,
            data: messageCreator.makeMessage(100 + params.channelId, 30, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getDelay(params) {
        var gesDelay = 24;
        var channelBias = 10;
        var channelMult = 1;
        return {
            packable: true,
            response: {
                id: "Delay",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(gesDelay, channelBias + params.channelId * channelMult, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {arrayedSpeakers 1..20} arrayedSpeakers
     * @param {channelId 0..3} channelId
     */
    setArray(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(19, 20 + params.channelId, params.value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {sizingValue 0.5..2.0} sizingValue
     * @param {channelId 0..3} channelId
     * @param {initEq = true, false} initEq
     */
    setSizing(params) {
        // Floating point FIX
        const val = (Math.round(params.value * 10) / 10);
        return {
            packable: true,
            data: messageCreator.makeMessage(19, 10 + params.channelId, (val * 10), 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {gain -15.0..15.0} gain
     * @param {channelId 0..3} channelId
     * @param {initEq = true, false} initEq
     */
    setHfShelf(params) {
        var eqBias = 3 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        var valueGain = params.value * 10;
        if (params.initEq) {
            var myParams = {
                type: 10,
                gain: params.value,
                freq: 7500,
                qual: 707 / 1000.0,
                channelId: params.channelId,
                eqnr: eqBias,
                init: true
            }
            return this.setEq(myParams);
        } else {
            return {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxGain, valueGain, 4, null, WRITE_4BYTE)
            }
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getHfShelf(params) {
        var eqBias = 3 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        return {
            packable: true,
            response: {
                id: "HfShelf",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(inputEqChannel, sidxGain, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {gain -15.0..15.0} value
     * @param {channelId 0..3} channelId
     * @param {initEq = true, false} initEq
     */
    setHuman(params) {
        var eqBias = 4 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        var valueGain = params.value * 10;
        if (params.initEq) {
            var myParams = {
                type: 1,
                gain: params.value,
                freq: 3000,
                qual: 1000 / 1000.0,
                channelId: params.channelId,
                eqnr: eqBias,
                init: true
            }
            return this.setEq(myParams);
        } else {
            return {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxGain, valueGain, 4, null, WRITE_4BYTE)
            }
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getHuman(params) {
        var eqBias = 4 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        return {
            packable: true,
            response: {
                id: "Human",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(inputEqChannel, sidxGain, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {gain -15.0..15.0} value
     * @param {channelId 0..3} channelId
     * @param {initEq = true, false} initEq
     */
    setLowBoost(params) {
        var eqBias = 5 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        var valueGain = params.value * 10;
        if (params.initEq) {
            var myParams = {
                type: 11,
                gain: params.value,
                freq: 150,
                qual: 707 / 1000.0,
                channelId: params.channelId,
                eqnr: eqBias,
                init: true
            }
            return this.setEq(myParams);
        } else {
            return {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxGain, valueGain, 4, null, WRITE_4BYTE)
            }
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getLowBoost(params) {
        var eqBias = 5 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        return {
            packable: true,
            response: {
                id: "LowBoost",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(inputEqChannel, sidxGain, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {gain -15.0..15.0} value
     * @param {channelId 0..3} channelId
     * @param {initEq = true, false} initEq
     */
    setSubSonic(params) {
        var eqBias = 6 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        var valueGain = params.value * 10;
        if (params.initEq) {
            var myParams = {
                type: 11,
                gain: params.value,
                freq: 30,
                qual: 707 / 1000.0,
                channelId: params.channelId,
                eqnr: eqBias,
                init: true
            }
            return this.setEq(myParams);
        } else {
            return {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxGain, valueGain, 4, null, WRITE_4BYTE)
            }
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getSubSonic(params) {
        var eqBias = 6 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        return {
            packable: true,
            response: {
                id: "SubSonic",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(inputEqChannel, sidxGain, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {meter 0..150} value
     * @param {channelId 0..3} channelId
     * @param {initEq = true, false} initEq
     */
    setDistance(params) {
        var eqBias = 7 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        var valueGain = params.value;
        if (params.initEq) {
            var myParams = {
                type: 1,
                gain: (params.value / 10.0),
                freq: 10000,
                qual: 3000 / 1000.0,
                channelId: params.channelId,
                eqnr: eqBias,
                init: true
            }
            return this.setEq(myParams);
        } else {
            return {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxGain, valueGain, 4, null, WRITE_4BYTE)
            }
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getDistance(params) {
        var eqBias = 7 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        return {
            packable: true,
            response: {
                id: "Distance",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(inputEqChannel, sidxGain, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {type 0==off, 1==peq, 10==hsh, 11==lsh} type
     * @param {gain -99.0..15.0} gain
     * @param {freq 5..30000} freq
     * @param {qual 0.1..100.0} qual
     * @param {channelId 0..3} channelId
     * @param {eqnr 0..6} eqnr
     * @param {initEq = true, false} initEq
     */
    setEqType(params) {
        var eqBias = params.eqnr * 4 + 11 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        if (params.initEq) {
            var myParams = {
                type: this.convertEqTypeFromUi(params.type),
                gain: params.gain,
                freq: params.freq,
                qual: params.qual,
                channelId: params.channelId,
                eqnr: eqBias,
                init: true
            }
            return this.setEq(myParams);
        } else {
            return {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, eqBias, this.convertEqTypeFromUi(params.type), 4, null, WRITE_4BYTE)
            }
        }
    }

    /**
     * @param {eqnr 0..9} eqnr
     * @param {channelId 0..3} channelId
     * @param {value 0==off} value
     */
    setSpeakerEqTypeEnabled(params) {
        return { packable: true, data: messageCreator.makeMessage(params.channelId + 80, params.eqnr * 4 + 10, params.value, 4, null, WRITE_4BYTE) };
    }

    /**
     * @param {eqnr 0..1} eqnr
     * @param {channelId 0..3} channelId
     * @param {value 0==off} value
     */
    setSpeakerXoverEnabled(params) {
        return { packable: true, data: messageCreator.makeMessage(params.channelId + 60, params.eqnr * 4 + 10, params.value, 4, null, WRITE_4BYTE) };
    }

    /**
     * @param {eqnr 0..9} eqnr
     * @param {channelId 0..3} channelId
     */
    getSpeakerEqTypeEnabled(params) {
        return {
            packable: true,
            response: {
                id: "SpeakerEqTypeEnabled",
                eqnr: params.eqnr,
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(params.channelId + 80, params.eqnr * 4 + 10, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     * @param {eqnr 0..1} eqnr
     * @param {channelId 0..3} channelId
     */
    getSpeakerXoverEnabled(params) {
        return {
            packable: true,
            response: {
                id: "SpeakerXoverEnabled",
                eqnr: params.eqnr,
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(params.channelId + 60, params.eqnr * 4 + 10, 0, 4, null, READ_4BYTE)
        }
    }

    convertEqTypeFromUi(uitype) {
        if (uitype == 2) {
            return 11;
        } else if (uitype == 3) {
            return 10;
        } else {
            return uitype;
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     * @param {eqnr 0..6} eqnr
     */
    getEqType(params) {
        var eqBias = params.eqnr * 4 + 11 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxType = eqBias + 0;
        return {
            packable: true,
            response: {
                id: "EqType",
                channelId: params.channelId,
                eqnr: params.eqnr
            },
            data: messageCreator.makeMessage(inputEqChannel, sidxType, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {type 0==off, 1==peq, 10==hsh, 11==lsh} type
     * @param {gain -99.0..15.0} gain
     * @param {freq 5..30000} freq
     * @param {qual 0.1..100.0} qual
     * @param {channelId 0..3} channelId
     * @param {eqnr 0..6} eqnr
     * @param {initEq = true, false} initEq
     */
    setEqFreq(params) {
        var eqBias = params.eqnr * 4 + 11 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxFreq = eqBias + 1;
        var valueFreq = params.freq;
        if (params.initEq) {
            var myParams = {
                type: this.convertEqTypeFromUi(params.type),
                gain: params.gain,
                freq: params.freq,
                qual: params.qual,
                channelId: params.channelId,
                eqnr: eqBias,
                init: true
            }
           return this.setEq(myParams);
        } else {
            return {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxFreq, valueFreq, 4, null, WRITE_4BYTE)
            }
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     * @param {eqnr 0..6} eqnr
     */
    getEqFreq(params) {
        var eqBias = params.eqnr * 4 + 11 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxFreq = eqBias + 1;
        return {
            packable: true,
            response: {
                id: "EqFreq",
                channelId: params.channelId,
                eqnr: params.eqnr
            },
            data: messageCreator.makeMessage(inputEqChannel, sidxFreq, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {type 0==off, 1==peq, 10==hsh, 11==lsh} type
     * @param {gain -99.0..15.0} gain
     * @param {freq 5..30000} freq
     * @param {qual 0.1..100.0} qual
     * @param {channelId 0..3} channelId
     * @param {eqnr 0..6} eqnr
     * @param {initEq = true, false} initEq
     */
    setEqGain(params) {
        var eqBias = params.eqnr * 4 + 11 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        var valueGain = params.gain * 10;
        if (params.initEq) {
            var myParams = {
                type: this.convertEqTypeFromUi(params.type),
                gain: params.gain,
                freq: params.freq,
                qual: params.qual,
                channelId: params.channelId,
                eqnr: eqBias,
                init: true
            }
            return this.setEq(myParams);
        } else {
            return {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxGain, valueGain, 4, null, WRITE_4BYTE)
            }
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     * @param {eqnr 0..6} eqnr
     */
    getEqGain(params) {
        var eqBias = params.eqnr * 4 + 11 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxGain = eqBias + 2;
        return {
            packable: true,
            response: {
                id: "EqGain",
                channelId: params.channelId,
                eqnr: params.eqnr
            },
            data: messageCreator.makeMessage(inputEqChannel, sidxGain, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {type 0==off, 1==peq, 10==hsh, 11==lsh} type
     * @param {gain -99.0..15.0} gain
     * @param {freq 5..30000} freq
     * @param {qual 0.1..100.0} qual
     * @param {channelId 0..3} channelId
     * @param {eqnr 0..6} eqnr
     * @param {initEq = true, false} initEq
     */
    setEqQual(params) {
        var eqBias = params.eqnr * 4 + 11 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxQual = eqBias + 3;
        var valueQual = params.qual * 1000;
        if (params.initEq) {
            var myParams = {
                type: this.convertEqTypeFromUi(params.type),
                gain: params.gain,
                freq: params.freq,
                qual: params.qual,
                channelId: params.channelId,
                eqnr: eqBias,
                init: true
            }
            return this.setEq(myParams);
        } else {
            return {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxQual, valueQual, 4, null, WRITE_4BYTE)
            }
        }
    }

/**
     *
     * @param {channelId 0..3} channelId
     * @param {eqnr 0..6} eqnr
     */
    getEqQual(params) {
        var eqBias = params.eqnr * 4 + 11 * 4 + 10;
        var inputEqChannel = params.channelId + 50;
        var sidxQual = eqBias + 3;
        return {
            packable: true,
            response: {
                id: "EqQual",
                channelId: params.channelId,
                eqnr: params.eqnr
            },
            data: messageCreator.makeMessage(inputEqChannel, sidxQual, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {type 0==off, 1==peq, 10==hsh, 11==lsh} type
     * @param {gain -99.0..15.0} gain
     * @param {freq 5..30000} freq
     * @param {qual 0.1..100.0} qual
     * @param {channelId 0..3} channelId
     * @param {eqnr eqbias} eqnr
     */
    setEq(params) {
        var inputEqChannel = params.channelId + 50;
        var eqBias = params.eqnr * 4 + 11 * 4 + 10;
        if (params.init) {
            eqBias = params.eqnr;
        }
        var sidxType = eqBias;
        var valueType = params.type;
        if (params.type == 2 || 3) {
            valueType = this.convertEqTypeFromUi(params.type);
        }
        var sidxFreq = eqBias + 1;
        var valueFreq = params.freq;
        var sidxGain = eqBias + 2;
        var valueGain = params.gain * 10;
        var sidxQual = eqBias + 3;
        var valueQual = params.qual * 1000;
        return [{
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxType, valueType, 4, null, WRITE_4BYTE)
            }, {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxFreq, valueFreq, 4, null, WRITE_4BYTE)
            }, {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxGain, valueGain, 4, null, WRITE_4BYTE)
            }, {
                packable: true,
                data: messageCreator.makeMessage(inputEqChannel, sidxQual, valueQual, 4, null, WRITE_4BYTE)
            }
        ]
    }

    /**
     *
     * @param {channelId 0..3} channelId
     * @param {invertphase = - == true, + == false} invertphase
     */
    setPhase(params) {
        var outSum = 34;
        var channelBias = 10;
        var value = params.invertphase ? 2 : 1;
        var sidxOutSum = channelBias + params.channelId;
        return {
            packable: true,
            data: messageCreator.makeMessage(outSum, sidxOutSum, (value << (params.channelId * 8)), 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getPhase(params) {
        var outSum = 34;
        var channelBias = 10;
        var sidxOutSum = channelBias + params.channelId;
        return {
            packable: true,
            response: {
                id: "Phase",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(outSum, sidxOutSum, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {sysunitlock = true, false} sysunitlock
     */
    setSysUnitLock(params) {
        var value = (params.value || params.sysunitlock) ? 1 : 0;
        return {
            packable: true,
            data: messageCreator.makeMessage(7, 60, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getSysUnitLock(params) {
        return {
            packable: true,
            response: {
                id: "SysUnitLock"
            },
            data: messageCreator.makeMessage(7, 60, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {sysunitpwd integer < 100000, 0=clear} sysunitpwd
     */
    setSysUnitPwd(params) {
        var value = (params.value || params.sysunitpwd || 0);
        return {
            packable: true,
            data: messageCreator.makeMessage(7, 61, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getSysUnitPwd(params) {
        return {
            packable: true,
            response: {
                id: "SysUnitPwd"
            },
            data: messageCreator.makeMessage(7, 61, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {syspclock = true, false} syspclock
     */
    setSysPcLock(params) {
        var value = (params.value || params.syspclock) ? 1 : 0;
        return {
            packable: true,
            data: messageCreator.makeMessage(7, 62, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getSysPcLock(params) {
        return {
            packable: true,
            response: {
                id: "SysPcLock"
            },
            data: messageCreator.makeMessage(7, 62, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {syspcpwd integer < 100000, 0=clear} syspcpwd
     */
    setSysPcPwd(params) {
        var value = (params.value || params.syspcpwd || 0);
        return {
            packable: true,
            data: messageCreator.makeMessage(7, 63, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getSysPcPwd(params) {
        return {
            packable: true,
            response: {
                id: "SysPcPwd"
            },
            data: messageCreator.makeMessage(7, 63, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {displaylock = true, false} displaylock
     */
    setDisplayLock(params) {
        var value = (params.value || params.displaylock) ? 1 : 0;
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 5, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getDisplayLock(params) {
        return {
            packable: true,
            response: {
                id: "DisplayLock"
            },
            data: messageCreator.makeMessage(6, 5, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {enablefallback = true, false} enablefallback
     */
    setEnableFallback(params) {
        var value = params.enablefallback ? 1 : 0;
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 13, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getEnableFallback(params) {
        return {
            packable: true,
            response: {
                id: "EnableFallback"
            },
            data: messageCreator.makeMessage(6, 13, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {fallbacksense = 10 - 3000} fallbacksense
     */
    setFallbackSense(params) {
        var value = params.fallbacksense;
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 19, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getFallbackSense(params) {
        return {
            packable: true,
            response: {
                id: "FallbackSense"
            },
            data: messageCreator.makeMessage(6, 19, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {inputsource = 0=Analog 1=AES 2=Dante} inputsource
     */
    setInputSource(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 10, params.inputsource, 4, null, WRITE_4BYTE)
        }
    }

     /**
     *
     * @param {none}
     */
    getInputSource(params) {
        return {
            packable: true,
            response: {
                id: "InputSource"
            },
            data: messageCreator.makeMessage(6, 10, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getActiveInputSource(params) {
        return {
            packable: true,
            response: {
                id: "ActiveInputSource"
            },
            data: messageCreator.makeMessage(6, 14, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {aesreceiver = 0=AES1+2 1=AES3+4 2=AES5+6 3=AES7+8} aesreceiver
     */
    setAesReceiver1(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 15, params.aesreceiver, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getAesReceiver1(params) {
        return {
            packable: true,
            response: {
                id: "AesReceiver1"
            },
            data: messageCreator.makeMessage(6, 15, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getAesReceiver1Lock(params) {
        return {
            packable: true,
            response: {
                id: "AesReceiver1Lock"
            },
            data: messageCreator.makeMessage(6, 40, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getAesReceiver1SampleRate(params) {
        return {
            packable: true,
            response: {
                id: "AesReceiver1SampleRate"
            },
            data: messageCreator.makeMessage(6, 41, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {aesreceiver = 0=AES1+2 1=AES3+4 2=AES5+6 3=AES7+8} aesreceiver
     */
    setAesReceiver2(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 16, params.aesreceiver, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getAesReceiver2(params) {
        return {
            packable: true,
            response: {
                id: "AesReceiver2"
            },
            data: messageCreator.makeMessage(6, 16, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getAesReceiver2Lock(params) {
        return {
            packable: true,
            response: {
                id: "AesReceiver2Lock"
            },
            data: messageCreator.makeMessage(6, 45, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {none}
     */
    getAesReceiver2SampleRate(params) {
        return {
            packable: true,
            response: {
                id: "AesReceiver2SampleRate"
            },
            data: messageCreator.makeMessage(6, 46, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {inputroute[0..3] = true or false} inputroute
     * @param {channelId 0..3} channelId
     */
    setAnalogRoute(params) {
        var channelBias = 20;
        var sidx = channelBias + params.channelId;
        var value = (params.inputroute[0] ? 1 : 0) + (params.inputroute[1] ? 2 : 0) + (params.inputroute[2] ? 4 : 0) + (params.inputroute[3] ? 8 : 0);
        return {
            packable: true,
            data: messageCreator.makeMessage(23, sidx, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getAnalogRoute(params) {
        var channelBias = 20;
        var sidx = channelBias + params.channelId;
        return {
            packable: true,
            response: {
                id: "AnalogRoute",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(23, sidx, 0, 4, null, READ_4BYTE)
        }
    }

    /*
     * @see setAnalogRoute
     */
    setDigitalRoute(params) {
        var channelBias = 30;
        var sidx = channelBias + params.channelId;
        var value = (params.inputroute[0] ? 1 : 0) + (params.inputroute[1] ? 2 : 0) + (params.inputroute[2] ? 4 : 0) + (params.inputroute[3] ? 8 : 0);
        return {
            packable: true,
            data: messageCreator.makeMessage(23, sidx, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getDigitalRoute(params) {
        var channelBias = 30;
        var sidx = channelBias + params.channelId;
        return {
            packable: true,
            response: {
                id: "DigitalRoute",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(23, sidx, 0, 4, null, READ_4BYTE)
        }
    }

    /*
     * @see setAnalogRoute
     */
    setDanteRoute(params) {
        var channelBias = 40;
        var sidx = channelBias + params.channelId;
        var value = (params.inputroute[0] ? 1 : 0) + (params.inputroute[1] ? 2 : 0) + (params.inputroute[2] ? 4 : 0) + (params.inputroute[3] ? 8 : 0);
        return {
            packable: true,
            data: messageCreator.makeMessage(23, sidx, value, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param {channelId 0..3} channelId
     */
    getDanteRoute(params) {
        var channelBias = 40;
        var sidx = channelBias + params.channelId;
        return {
            packable: true,
            response: {
                id: "DanteRoute",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(23, sidx, 0, 4, null, READ_4BYTE)
        }
    }

    getAmpStateMaxSize() {
        return {
            packable: true,
            response: {
                id: "AmpStateMaxSize"
            },
            data: messageCreator.makeMessage(13, 1, 0, 4, null, READ_4BYTE)
        }
    }

    getAmpStateSize() {
        return {
            packable: true,
            response: {
                id: "AmpStateSize"
            },
            data: messageCreator.makeMessage(13, 2, 0, 4, null, READ_4BYTE)
        }
    }

    getAmpStatePacketSize() {
        return {
            packable: true,
            response: {
                id: "AmpStatePacketSize"
            },
            data: messageCreator.makeMessage(13, 3, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {packetId 0..126} packetId
     */
    getAmpStatePacket(params) {
        return {
            packable: true,
            response: {
                id: "AmpStatePacket",
                packetId: params.packetId
            },
            data: messageCreator.makeMessage(13, (10 + params.packetId + 1), 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {packetId 0..126} packetId
     * @param {value[1024]} value = buffer of 1024 byte
     */
    setAmpStatePacket(params) {
        const data = [];
        for (var i = 0; i < 1024; i++) {
            data.push(i < params.value.length ? params.value[i] : 0);
        }

        // console.log(params.packetId + " data pushed to packet: " + data);

        return {
            packable: true,
            data: messageCreator.makeMessage(13, (10 + params.packetId + 1), data, data.length, null, WRITE_4BYTE)
        }
    }

    getAmpStateMeta() {
        return {
            packable: true,
            response: {
                id: "AmpStateMeta",
                packetId: 0
            },
            data: messageCreator.makeMessage(13, 10, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param {value[1024]} value = buffer of 1024 byte
     */
    setAmpStateMeta(params) {
        const data = [];
        for (var i = 0; i < 1024; i++) {
            data.push(i < params.value.length ? params.value[i] : 0);
        }

        return {
            packable: true,
            data: messageCreator.makeMessage(13, 10, data, data.length, null, WRITE_4BYTE)
        }
    }

    /*
     * needs ok message to see if finished
     */
    storeAmpState() {
        return {
            packable: true,
            data: messageCreator.makeMessage(13, 9, 1234, 4, null, WRITE_4BYTE)
        }
    }

        /**
     *
     * @param {idx} idx
     * @param {sidx} sidx
     * @param {msg} msg
     * @param {size} size
     */
    testParams(value) {
        var data;
        var lng = 4;
        if (value.size) lng = value.size;
        if (value.msg) {
            data = {
                packable: true,
                data: messageCreator.makeMessage(value.idx, value.sidx, value.msg, lng, null, WRITE_4BYTE)
            }
        } else {
            data = {
                packable: true,
                data: messageCreator.makeMessage(value.idx, value.sidx, 0, 0, null, READ_4BYTE)
            }
        }
        return data;
    }

    /**
     *
     * @param {channelId} channelId = 0..3
     * @param {measureOnOff 1=On, 0=Off} measureOnOff = 1, 0
     * @param {damping in db * -10} damping = 10..-80
     * @param {frequency in Hz} frequency = 20..25000
     * @param {minResistance in ohm} minR = 1..16
     * @param {maxResistence in ohm} maxR = 2..50
     */
     setSpeakerTestparam(params) {
        const ch = 100 + (params.channelId * 2);
        const onoff = params.measureOnOff;
        var dam = Math.pow(10, ((params.damping) / 20.0));
        if (dam > 0.05) dam = 0.05;
        const freq = params.freq;
        const minR = params.minR;
        const maxR = params.maxR;
        const datawords = {
            onoff: onoff,
            dam: floatToIntBits(dam),
            freq: freq,
            minR: floatToIntBits(minR),
            maxR: floatToIntBits(maxR)
        };
        return {
            packable: true,
            data: messageCreator.makeMessage(21, ch, datawords, 20, null, WRITE_FLOAT)
        }
        // messung kann nur mit den daten aus SpeakerTestparam gemacht werden und kann angetriggert werden setSiggenStartAutotest
        // daten in testspeaker schreiben den messen und sehen was passiert, mit getSpeakerTestState die daten checken
    }

    /**
     *
     * @param {ChannelId 0..3} channelId = 0..3
     * @returns null
     */
    getSpeakerTestparam(params) {
        const ch = 100 + (params.channelId * 2);
        return {
            packable: true,
            response: {
                id: "SpeakerTestparam",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(21, ch, 0, 4, null, READ_4BYTE)
        }
    }

    getSpeakerResistance(params) {
        return {
            packable: true,
            response: {
                id: "SpeakerResistance",
                channelId: params.channelId
            },
            data: messageCreator.makeMessage(21, 101 + (params.channelId * 2), 0, 4, null, READ_4BYTE)
        }
    }

    setSiggenMux(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(21, 13, params.value, 4, null, WRITE_4BYTE)
        }
    }

    getSiggenMux() {
        return {
            packable: true,
            response: {
                id: "SiggenMux"
            },
            data: messageCreator.makeMessage(21, 13, 0, 4, null, READ_4BYTE)
        }
    }

    getSpeakerTestState() {
        return {
            packable: true,
            response: {
                id: "SpeakerTestState"
            },
            data: messageCreator.makeMessage(21, 14, 0, 4, null, READ_4BYTE)
        }
    }

    setSiggenStartAutotest() {
        return {
            packable: true,
            data: messageCreator.makeMessage(21, 9, 1, 4, null, WRITE_4BYTE)
        }
    }

    /**
     *
     * @param { mode 0=off, 1=Lp, 2=Hp, 3=LpTrigger, 4=HpTrigger} value = 0..4
     * @returns null
     */
    setInputAuxMode(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 51, params.value, 4, null, WRITE_4BYTE)
        }
    }

    getInputAuxMode() {
        return {
            packable: true,
            response: {
                id: "InputAuxMode"
            },
            data: messageCreator.makeMessage(6, 51, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     *
     * @param { mode 0=off, 1=immer Aktiv, 2=wenn pilotton erkannt, 3=wenn alarm extern Gesetzt in 6.53, auxport pin4 high} value = 0..3
     * audio Umschaltung bei Alarm auf Aux Audio Eingang
     * @returns null setInputAlarmAudioMode
     */
     setInputAlarmAudioMode(params) {
        return {
            packable: true,
            data: messageCreator.makeMessage(6, 52, params.value, 4, null, WRITE_4BYTE)
        }
    }

    getInputAlarmAudioMode() {
        return {
            packable: true,
            response: {
                id: "InputAlarmAudioMode"
            },
            data: messageCreator.makeMessage(6, 52, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     * externe über BMZ alarm gesetzt am AuxPort Pin4?
     * @returns status vom aux alarm input: 0 kein alarm gesetzt, 1 alarm gesetzt
     */
    getAuxAudioArlamState() {
        return {
            packable: true,
            response: {
                id: "AuxAudioArlamState"
            },
            data: messageCreator.makeMessage(6, 53, 0, 4, null, READ_4BYTE)
        }
    }

    /**
     * Aux Status aus 6.53, 6.52, 6.51
     * @returns bit0 alarm getzt 6.53, bit1 Aktuelle Einstellung AlarmAudioMode 6.52, bit2 Aktuelle Einstellung Pilotton Erkennung 6.51
     */
    getAuxState() {
        return {
            packable: true,
            response: {
                id: "AuxState"
            },
            data: messageCreator.makeMessage(6, 50, 0, 4, null, READ_4BYTE)
        }
    }

    getAuxSetAmpOk() {
        return {
            packable: true,
            response: {
                id: "AuxSetAmpOk"
            },
            data: messageCreator.makeMessage(6, 54, 0, 4, null, READ_4BYTE)
        }
    }
}

function floatToIntBits(f) {
    var int8 = new Int8Array(4);
    var int32 = new Int32Array(int8.buffer, 0, 1);
    var float32 = new Float32Array(int8.buffer, 0, 1);
    float32[0] = f;
    return int32[0];
}
const funktionsLib = new FunktionsLib();

module.exports = {
    funktionsLib,
    FunktionsLib
}
